#!/bin/bash

echo "================================================"
echo "Raspberry Pi AI HAT Object Detection"
echo "================================================"

# Default rotation
ROTATION=0

# Ask if user wants to rotate
read -rp "Do you want to rotate the camera? (Y/N): " rotate_answer

if [[ "$rotate_answer" =~ ^([Yy]|[Yy][Ee][Ss])$ ]]; then
    while true; do
        read -rp "Enter rotation in degrees (90, 180, 270): " ROT
        if [[ "$ROT" == "90" || "$ROT" == "180" || "$ROT" == "270" ]]; then
            ROTATION=$ROT
            break
        else
            echo "❌ Invalid input. Please enter 90, 180, or 270."
        fi
    done
fi

echo ""
echo "➡️ Starting object detection with rotation: $ROTATION°"
echo "Press Ctrl+C to exit the live feed."

# Run object detection using the Hailo YOLOv8 JSON
DISPLAY=:0 rpicam-hello -t 0 \
  --post-process-file /usr/share/rpi-camera-assets/hailo_yolov8_inference.json \
  --lores-width 640 --lores-height 640 \
  --rotation "$ROTATION"
